/* DOES NOT USE BUILT-IN DETECTION FUNCTIONALITY!
 * alert tcp $EXTERNAL_NET any -> $HOME_NET 389 (msg:"EXPLOIT Novell eDirectory LDAP null search parameter buffer overflow attempt"; flow:to_server,established; content:"|a9|"; reference:cve,2008-1809; reference:bugtraq,30175; reference:url,www.novell.com/support/viewContent.do?externalId=3843876; classtype:attempted-admin; sid:15973;)
*/
/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util_ber.h"

/* declare detection functions */
int rule15973eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule15973flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule15973option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule15973flow0
    }
};
#ifndef CONTENT_FAST_PATTERN
#define CONTENT_FAST_PATTERN 0
#endif
// content:"|A9|", depth 0, fast_pattern; 
static ContentInfo rule15973content1 = 
{
    (uint8_t *) "|A9|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15973option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15973content1
    }
};

/* references for sid 15973 */
/* reference: bugtraq "30175"; */
static RuleReference rule15973ref1 = 
{
    "bugtraq", /* type */
    "30175" /* value */
};

/* reference: cve "2008-1809"; */
static RuleReference rule15973ref2 = 
{
    "cve", /* type */
    "2008-1809" /* value */
};

/* reference: url "www.novell.com/support/viewContent.do?externalId=3843876"; */
static RuleReference rule15973ref3 = 
{
    "url", /* type */
    "www.novell.com/support/viewContent.do?externalId=3843876" /* value */
};

static RuleReference *rule15973refs[] =
{
    &rule15973ref1,
    &rule15973ref2,
    &rule15973ref3,
    NULL
};

/* metadata for sid 15973 */
/* metadata:; */
static RuleMetaData rule15973service1 =
{
    "service ldap"
};

static RuleMetaData rule15973policy1 =
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule15973metadata[] =
{
    &rule15973service1,
    &rule15973policy1,
    NULL
};

RuleOption *rule15973options[] =
{
    &rule15973option0,
    &rule15973option1,
    NULL
};

Rule rule15973 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
   
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
   
       "389", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       15973, /* sigid */
       5, /* revision */
   
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "SERVER-OTHER Novell eDirectory LDAP null search parameter buffer overflow attempt",     /* message */
       rule15973refs /* ptr to references */
       ,rule15973metadata
   },
   rule15973options, /* ptr to rule options */
   &rule15973eval, /* DOES NOT use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule15973eval(void *p) {
   const uint8_t *cursor_normal = 0, *end_of_payload;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   BER_ELEMENT ber_element;
   int retval;

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;
    
   // flow:established, to_server;
   if(checkFlow(p, rule15973options[0]->option_u.flowFlags) <= 0 )
      return RULE_NOMATCH;

   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   // Universal Sequence
   retval = ber_point_to_data(sp, &cursor_normal, 0x30);
   if(retval < 0)
      return RULE_NOMATCH;

   // Message ID
   retval = ber_skip_element(sp, &cursor_normal, 0x02);
   if(retval < 0)
      return RULE_NOMATCH;

   // Search Request
   retval = ber_point_to_data(sp, &cursor_normal, 0x63);
   if(retval < 0)
      return RULE_NOMATCH;

   // Base DN
   retval = ber_skip_element(sp, &cursor_normal, 0x04);
   if(retval < 0)
      return RULE_NOMATCH;

   // Scope
   retval = ber_skip_element(sp, &cursor_normal, 0x0a);
   if(retval < 0)
      return RULE_NOMATCH;

   // Dereference Aliases
   retval = ber_skip_element(sp, &cursor_normal, 0x0a);
   if(retval < 0)
      return RULE_NOMATCH;

   // Size Limit
   retval = ber_skip_element(sp, &cursor_normal, 0x02);
   if(retval < 0)
      return RULE_NOMATCH;

   // Time Limit
   retval = ber_skip_element(sp, &cursor_normal, 0x02);
   if(retval < 0)
      return RULE_NOMATCH;

   // Attributes only (we're going to ignore this and all should work out okay)
   retval = ber_skip_element(sp, &cursor_normal, 0x01);
   if(retval < 0)
      return RULE_NOMATCH;

   // Filter.  If filter len is 0, alert
   retval = ber_get_element(sp, cursor_normal, &ber_element);
   if(retval < 0 || ber_element.type != 0xa9)
      return RULE_NOMATCH;

   if(ber_element.data_len == 0)
      return RULE_MATCH;
 
   return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule15973,
    NULL
};
*/

